IF OBJECT_ID('V_CUPOMFISCAL') IS NOT NULL 
	DROP VIEW V_CUPOMFISCAL 
GO 

CREATE VIEW V_CUPOMFISCAL
AS
SELECT 	VD.CD_EMP, VD.CD_FILIAL,VD.CD_CX,VD.DT_VD, VD.DT_VD AS DT_CUPOM, VD.NR_ECF AS NR_COO, 0 AS CD_CTR
        , VD.NR_ORC,VD.NR_PED_TELEVD,VD.ORIG_ORC AS ORIGEM_ORC,VD.CD_VD,VD.NR_ECF,VD.ST_VD,VD.DT_CAD, VD.CONT_CUPOM_FISC AS CONTADOR_CUPOM_FISCAL
        , CASE WHEN DATEPART(YEAR,VD.HR_VD) = 1900 THEN VD.DT_VD + VD.HR_VD ELSE VD.HR_VD END AS HR_VD
        , FILIAL.CGC AS CGC_FILIAL, FILIAL.NM_FANT AS NM_FILIAL
        , VD.CD_CLI,COALESCE(VD.CGC_CPF,'') AS CGC_CLI, CLI.RZ_CLI AS NM_CLI, VD.NR_CARTAO_MARKA AS NUMERO_CARTAO
        , VD_CONV.CD_CONV,CONV.CD_CLI AS CD_CLI_CONV, CLI_CONV.CGC_CPF AS CGC_CONV, COALESCE(CLI_CONV.RZ_CLI, CONV.DS_CONV) AS NM_CONV, COALESCE(VD_CONV.QTD_DIAS_PRORROG,0) AS DIAS_PRORROG_CONV
        , VD.VLR_LIQ_VD, VD.VLR_TOT_PROD , VD.VLR_VD, VD.VLR_DESC, VD.VLR_DESC_ITENS
        , VD.VLR_DINH,0 AS VLR_TROCO,VD.VLR_CONV,VD_CONV.PARC  AS QT_PARC_CONV,VD.VLR_CARTAO,VD.VLR_TICKETS,VD.VLR_DUP
        , VD.VL_CHQS_A_VISTA AS VALOR_CHEQUE_A_VISTA, VD.VL_CHQS_A_PRZ AS VALOR_CHEQUE_A_PRAZO
        , NCC.CD_CTR_NCC,VD.VLR_NCC
        , VD.NR_OPER_CEL,VD.NR_CEL_RECARGA,VD.VLR_RECARGA_CEL,OPERCEL.NM_OPER_CEL
        , VD.NM_COMPRADOR, VD.DADOS_ADICIONAIS, CX.NR_SERIE_IMP AS NR_SERIE_ECF, VD.VS_PDV AS VERSAO_PDV, VD.VS_PDV_RC AS VERSAO_PDV_RC
        , CASE WHEN COALESCE(VD.VLR_DINH, 0) = 0 THEN NULL ELSE 1 END AS CONTEM_DINHEIRO
        , CASE WHEN COALESCE(CTR_CONV.CD_VD,0) = 0 THEN NULL ELSE 1 END AS CONTEM_CONVENIO
        , CASE WHEN COALESCE(VD.VLR_DUP,  0) = 0 THEN NULL ELSE 1 END AS CONTEM_DUPLICATA
        , CASE WHEN COALESCE(NCC.CD_CTR_NCC, 0) = 0 THEN NULL ELSE 1 END AS CONTEM_NCC
        , CASE WHEN COALESCE(VD.VLR_RECARGA_CEL,  0) = 0 THEN NULL ELSE 1 END AS CONTEM_RECARGA_CEL
        , OPERADOR.CD_USU AS CD_OPERADOR,OPERADOR.NM_USU AS NM_OPERADOR
        , VD.CD_USU_CANCEL,USU_CANCEL.NM_USU AS NM_USU_CANCEL, VD.CD_MT_CANCEL AS CODIGO_MOTIVO_CANCELAMENTO
        , NULLIF(VD.ST_VD,0)  AS  IS_CANCELADO,CASE WHEN VD.ST_CANC_PAF = 1 THEN 1 ELSE 0 END AS IS_CANCELADO_PAF, COALESCE(VD.ST_CANC_PAF,0) AS ST_CANC_PAF
        , COALESCE(AUDIT.CD_PROCD, 0) AS CD_OUTRO_PROCEDIMENTO, COALESCE(AUDIT.CD_USU, 0) AS CD_USU_PROCEDIMENTO
        , VD.CD_CLI_PBM
        , 0 AS REGISTROALTERADO
        , VD.VD_TROCA_FIDEL AS IS_DEBITAR_PONTOS, COALESCE(VD.VALOR_IBPT, 0) AS VALOR_IBPT, COALESCE(VD.PERC_IBPT, 0) AS PERCENTUAL_IBPT
        ,VD.FLAG_NFCE,NF_SAI.CD_NF AS CD_NF_SAI
FROM    PDV_VD VD
INNER	JOIN PDV_CX CX ON VD.CD_EMP = CX.CD_EMP AND VD.CD_FILIAL = CX.CD_FILIAL AND VD.CD_CX = CX.CD_CX
LEFT    JOIN PRC_FILIAL FILIAL ON VD.CD_EMP = FILIAL.CD_EMP AND VD.CD_FILIAL = FILIAL.CD_FILIAL
LEFT	JOIN PDV_VD_EST_NF_SAI NF_SAI ON VD.CD_EMP = NF_SAI.CD_EMP AND VD.CD_FILIAL = NF_SAI.CD_FILIAL AND VD.CD_VD = NF_SAI.CD_VD
LEFT	JOIN EST_NFCE_ENV E_NFCE ON VD.CD_EMP = E_NFCE.CD_EMP AND VD.CD_FILIAL = E_NFCE.CD_FILIAL AND VD.NR_ECF = E_NFCE.CD_NF
LEFT    JOIN RC_CLI CLI ON VD.CD_EMP = CLI.CD_EMP AND VD.CD_CLI = CLI.CD_CLI
LEFT	JOIN PDV_VD_DEV_NCC_PDV_VD NCC ON NCC.CD_EMP = VD.CD_EMP AND NCC.CD_FILIAL = VD.CD_FILIAL AND NCC.CD_VD = VD.CD_VD
LEFT	JOIN PDV_VD_RC_VD_CONV CTR_CONV ON VD.CD_EMP = CTR_CONV.CD_EMP AND VD.CD_FILIAL = CTR_CONV.CD_FILIAL AND VD.CD_VD = CTR_CONV.CD_VD
LEFT	JOIN RC_VD_CONV VD_CONV ON CTR_CONV.CD_EMP = VD_CONV.CD_EMP AND CTR_CONV.CD_FILIAL = VD_CONV.CD_FILIAL AND CTR_CONV.CD_CTR = VD_CONV.CD_CTR
LEFT    JOIN RC_CLI_CONV CONV ON VD_CONV.CD_EMP = CONV.CD_EMP AND VD_CONV.CD_CONV = CONV.CD_CONV
LEFT    JOIN RC_CLI CLI_CONV ON CONV.CD_EMP = CLI_CONV.CD_EMP AND CONV.CD_CLI = CLI_CONV.CD_CLI
LEFT    JOIN GLB_OPER_CEL OPERCEL	ON VD.CD_EMP = OPERCEL.CD_EMP AND VD.NR_OPER_CEL = OPERCEL.NR_OPER_CEL
LEFT    JOIN GLB_USU OPERADOR  ON VD.CD_USU_OPE = OPERADOR.CD_USU
LEFT 	JOIN GLB_USU USU_CANCEL ON  VD.CD_USU_CANCEL = USU_CANCEL.CD_USU
LEFT	JOIN PDV_VD_PROCD_AUDIT AUDIT ON VD.CD_EMP = AUDIT.CD_EMP AND VD.CD_FILIAL = AUDIT.CD_FILIAL AND VD.CD_VD = AUDIT.CD_VD AND AUDIT.CD_PROCD IN (90,91,93,94)